"use server"
import { languageArray, thisLocale } from '@/constants/projects';
import { cookies } from 'next/headers';

export async function getLanguageFromCookiesServer(): Promise<ProjectLanguage> {
  const cookieStore = cookies();
  const languageCookie = cookieStore.get('lang')?.value;
  const supportedLanguages: string[] = languageArray.join().toLowerCase().split(",")
  if (languageCookie && (supportedLanguages.includes(languageCookie as ProjectLanguage) || supportedLanguages.includes(languageCookie.toLowerCase() as ProjectLanguage))) {
    return languageCookie as ProjectLanguage;
  }

  return thisLocale === 'fa_IR' ? 'fa' : 'en'
}
