import { languageArray, thisLocale } from '@/constants/projects';
import Cookies from 'universal-cookie';

export function getLanguageFromCookiesClient(): ProjectLanguage {
  const cookies = new Cookies();
  const languageCookie = cookies.get('lang') as ProjectLanguage | undefined;

  const supportedLanguages: string[] = languageArray.join().toLowerCase().split(",")

  if (languageCookie && (supportedLanguages.includes(languageCookie) || supportedLanguages.includes(languageCookie.toLowerCase() as ProjectLanguage))) {
    return languageCookie;
  }

  return thisLocale === 'fa_IR' ? 'fa' : 'en'
}
