"use client"
import { useEffect } from "react";
import { detectPlatform } from "../detectPlatform";

interface RedirectProps {
  nextPage: string;
}

const RedirectToNewTab: React.FC<RedirectProps> = ({ nextPage }) => {

  const platform = detectPlatform()

  useEffect(() => {
    if (nextPage) {
      if (platform !== "webApp") window.open(nextPage, "_blank");
      else window.location.assign(nextPage)
    }
  }, [nextPage]);

  return null;
};

export default RedirectToNewTab;
