
import en from "../locales/en/translate.json";
import fa from "../locales/fa/translate.json";
import Sp from "../locales/es/translate.json";
import it from "../locales/it/translate.json";
import Br from "../locales/pt/translate.json";
import PL from "../locales/pt/translate.json";
import { getLanguageFromCookiesClient } from "./question/getLanguage.client";

type Translations = typeof en;

const lang = getLanguageFromCookiesClient()


const translationsMap: Record<ProjectLanguage, Translations> = {
  en,
  fa,
  Sp,
  it,
  Br,
  PL
};

export const getTranslate = (language: ProjectLanguage = lang) => {
  return { t: translationsMap[language], language };
};
