export function extractNumbers(str: string): string {
  const farsiDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
  const arabicDigits = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
  const hindiDigits = ['०', '१', '२', '३', '४', '५', '६', '७', '८', '९'];
  let result = '';
  for (const char of str) {
    if (/[0-9]/.test(char)) {
      result += char;
    }
    else if (farsiDigits.includes(char)) {
      result += farsiDigits.indexOf(char);
    }
    else if (arabicDigits.includes(char)) {
      result += arabicDigits.indexOf(char);
    }
    else if (hindiDigits.includes(char)) {
      result += hindiDigits.indexOf(char);
    }
  }
  return result;
}

export default extractNumbers;