export const detectPlatform = (userAgent?: string) => {
  // If no userAgent is provided, try to use the browser's navigator
  if (!userAgent) {
    if (typeof window === "undefined") return "server";
    userAgent = navigator.userAgent;
  }

  // Prioritize iOS detection
  if (/Mac|macintosh|Macintosh|iPhone|iPad|iPod/i.test(userAgent) && /WebView/i.test(userAgent)) {
    return "iOS";
  }

  // Check for Flutter WebView (this part still only works on the client)
  if (typeof window !== "undefined" && window.flutter_inappwebview) {
    return /Mac|macintosh|Macintosh|iPhone|iPad|iPod/i.test(userAgent) ? "iOS" : "android";
  }

  return "webApp";
};