interface CallFlutterHandlerProps {
  fallback?: () => void;
  flutterHandlerName: string;
  flutterHandlerParams: string[];
}

export const callFlutterHandlerOrFallback = ({
  fallback,
  flutterHandlerName,
  flutterHandlerParams,
}: CallFlutterHandlerProps) => {
  if ("flutter_inappwebview" in window) {
    window.flutter_inappwebview!.callHandler(flutterHandlerName, flutterHandlerParams.join(",")).catch((error: any) => {
      console.error(`Error calling handler ${flutterHandlerName}:`, error);
    });
  } else {
    fallback?.();
  }
};