interface ParamsItem {
  key: string;
  title: string;
  value: string;
}

interface LineBar {
  title: string;
  value: string;
  label: string;
  scaleList: string[];
}

interface Params {
  title: string;
  image: string;
  params: ParamsItem[];
  lineBar: LineBar;
}

interface ParamsSet {
  before: Params;
  after: Params;
}
interface Warning {
  title: string;
  description: string;
}

interface Percentage {
  value: string;
  description: string;
}

export interface PreCheckoutV2Props {
  token: string;
  code: string;
  isResult: string;
  videoTitle: string
  videoUrl: string
  header: PreCheckoutHeader;
  params: ParamsSet;
  warning: Warning;
  hint: string;
  percentage: Percentage;
  button: PreCheckoutButton;
}

export interface PreCheckoutHeader {
  color: string;
  bgColor: string;
  image: string;
  text: string;
}

export interface PreCheckoutButton {
  text: string;
  link: string;
  bgColor: string;
  color: string;
}

export interface SummeryVideo {
  link: string;
  text: string;
}

export interface HighlightLineBar {
  title: string;
  value: string;
  label: string;
  scaleList: string[];
}

export interface SummeryLineBar extends HighlightLineBar {
  warningTitle: string;
  warningDescription: string;
}

export interface SummeryItem {
  icon: string;
  title: string;
  description: string;
  descriptionColor: string;
}

export interface PreCheckoutSummery {
  title: string;
  video: SummeryVideo;
  lineBar: SummeryLineBar;
  borderImage: string;
  items: SummeryItem[];
}

export interface HighlightItem {
  icon: string;
  title: string;
  description: string;
  descriptionColor: string;
}

export interface HighlightPercentage {
  value: string;
  description: string;
  afterText: string | null | undefined;
}

export interface PreCheckoutHighlight {
  title: string;
  lineBar: HighlightLineBar;
  borderImage: string;
  items: HighlightItem[];
  percentage: HighlightPercentage;
}

export interface PreCheckoutResultProps {
  token?: string | undefined;
  code?: string | undefined;
  header: PreCheckoutHeader;
  button: PreCheckoutButton;
  summery: PreCheckoutSummery;
  highlight: PreCheckoutHighlight;
}

export interface ResultBoxListItem {
  icon: string;
  title: string;
  description: string;
  descriptionColor: string;
}

// V2 =========================================================================================
export interface PreCheckoutResultPropsV2 {
  token: string;
  code: string;
  isResult: string; // Consider changing to boolean if possible
  videoTitle: string;
  videoUrl: string;
  header: Header;
  params: AnalysisParams;
  warning: Warning;
  hint: string;
  percentage: Percentage;
  button: Button;
}

interface Header {
  color: string;
  bgColor: string;
  image: string;
  text: string;
}

interface AnalysisParams {
  before: Condition;
  after: Condition;
}

interface Condition {
  title: string;
  image: string;
  params: ConditionParam[];
  lineBar: LineBar;
}

interface ConditionParam {
  key: string;
  title: string;
  value: string;
}

interface LineBar {
  title: string;
  value: string;
  label: string;
  scaleList: string[];
}

interface Warning {
  title: string;
  description: string;
}

interface Percentage {
  value: string;
  description: string;
}

interface Button {
  text: string;
  link: string;
  bgColor: string;
  color: string;
}
