"use client";
import { useWindowSize } from "@/hooks";
import useTranslate from "@/hooks/useTranslate";
import { Slide, ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

const CustomToast = () => {
  const { width } = useWindowSize();
  const { language } = useTranslate();

  return (
    <ToastContainer
      position={language === "fa" ? "bottom-right" : "bottom-left"}
      autoClose={2000}
      hideProgressBar={false}
      newestOnTop={true}
      closeOnClick
      rtl={language === "fa"}
      draggable={language === "fa"}
      style={{
        right: width < 768 ? 0 : 10,
      }}
      toastClassName={language === "fa" ? "lang-fa" : "lang-en"}
      theme="colored"
      limit={3}
      transition={Slide}
    />
  );
};

export default CustomToast;
