'use client'

import { getLanguageFromCookiesClient } from '@/utils/question/getLanguage.client'
import React, { createContext, useContext, useState, useEffect, ReactNode } from 'react'

interface LanguageContextProps {
  language: ProjectLanguage
  setLanguage: (lang: ProjectLanguage) => void
}

const LanguageContext = createContext<LanguageContextProps>({
  language: getLanguageFromCookiesClient(),
  setLanguage: () => { },
})

interface LanguageProviderProps {
  children: ReactNode
  initialLanguage: ProjectLanguage
}

export const LanguageProvider: React.FC<LanguageProviderProps> = ({ children, initialLanguage }) => {
  const [language, setLanguageState] = useState<ProjectLanguage>(initialLanguage)
  useEffect(() => {
    const lang = getLanguageFromCookiesClient()

    if (lang && lang !== language) {
      setLanguageState(lang)
    }
  }, [language])

  const setLanguage = (lang: ProjectLanguage) => {
    const Cookies = require('universal-cookie').default
    const cookies = new Cookies()
    cookies.set('lang', lang, { path: '/', maxAge: 60 * 60 * 24 * 30 })
    setLanguageState(lang)
  }

  return (
    <LanguageContext.Provider value={{ language, setLanguage }}>
      {children}
    </LanguageContext.Provider>
  )
}

export const useLanguageContext = (): LanguageContextProps => useContext(LanguageContext)
export default LanguageProvider
