"use client";
import { colors } from "@/theme";
import styled from "styled-components";

interface RangeInputProps extends Omit<React.InputHTMLAttributes<HTMLInputElement>, "onChange" | "type"> {
  onRangeChange: (value: string) => void;
  value: string;
  step?: number;
}

const RangeInput: FC<RangeInputProps> = ({ onRangeChange, value, step = 1, ...props }) => {
  const percentage = +value;

  return (
    <StyledRangeInput
      type="range"
      onChange={e => onRangeChange(e.target.value)}
      percentage={percentage}
      value={value}
      step={step}
      {...props}
    />
  );
};

export default RangeInput;

const StyledRangeInput = styled.input<{ percentage: number }>`
  width: 100%;
  -webkit-appearance: none;
  appearance: none;
  cursor: pointer;
  outline: none;
  border-radius: 15px;
  height: 6px;
  background: ${({ percentage }) => `linear-gradient(to right, ${colors.primary} ${percentage}%, #ccc ${percentage}%)`};

  &::-webkit-slider-thumb {
    -webkit-appearance: none;
    appearance: none;
    height: 25px;
    width: 25px;
    background-color: ${colors.primary};
    border-radius: 50%;
    border: none;
    transition: 0.2s ease-in-out;
    border: 2px solid ${colors.white};
  }
`;