'use client';

import { useState, useEffect } from "react";

import en from "@/locales/en/translate.json";
import fa from "@/locales/fa/translate.json";
import Sp from "@/locales/es/translate.json";
import it from "@/locales/it/translate.json";
import PL from "@/locales/pt/translate.json";
import Br from "@/locales/pt/translate.json";
import { useLanguageContext } from "@/providers/LanguageProvider";

type Translations = typeof en;

const translationsMap: Record<ProjectLanguage, Translations> = {
  en,
  fa,
  Sp,
  it,
  Br,
  PL
};

const useTranslate = () => {
  const { language } = useLanguageContext();
  const [translations, setTranslations] = useState<Translations>(translationsMap[language]);

  useEffect(() => {
    if (translationsMap[language]) {
      setTranslations(translationsMap[language]);
    } else {
      console.warn(`Translations for language "${language}" not found.`);
      setTranslations({} as Translations);
    }
  }, [language]);

  return { t: translations, language };
};

export default useTranslate;