"use client"
import { detectPlatform } from "@/utils/detectPlatform"
import { useEffect, useState } from "react"

export const usePlatform = () => {

  const thisPlatform = detectPlatform()
  const [platform, setPlatform] = useState<typeof thisPlatform>(thisPlatform)

  useEffect(() => {
    if (thisPlatform !== "server") {
      setPlatform(detectPlatform())
    }
  }, [thisPlatform])

  const isAndroid = platform === 'android'
  const isIos = platform === 'iOS'
  const isWeb = platform === 'webApp'
  const isNotWeb = platform !== 'webApp'

  return {
    platform,
    isAndroid,
    isIos,
    isWeb,
    isNotWeb
  }
}