"use client"
import SendPhoneModal from "./Modal"
import Cookies from "universal-cookie";
import { useRouter } from "next/navigation";
import { useMutation } from "@tanstack/react-query";
import { useModalController } from "react-modal-pro";
import { sendPhoneNumber } from "./sendPhone.services";

const SendPhone = () => {
  const router = useRouter()
  const { handleCloseModal } = useModalController("send_phone")
  const { isLoading, mutate } = useMutation({
    mutationKey: ["sendPhone"],
    mutationFn: async (phoneNumber: string) => {
      const token = new Cookies().get("token");
      return await sendPhoneNumber(Number(phoneNumber), token);
    },
    onSuccess(_, phoneNumber) {
      handleCloseModal()
      const cookies = new Cookies()
      cookies.set("phoneNumber", phoneNumber)
      if (cookies.get("paymentURL")) router.push(cookies.get("paymentURL"))
    },
  })

  const handleSubmit = (phoneNumber: string) => mutate(phoneNumber)

  return (
    <SendPhoneModal handleSubmit={handleSubmit} isLoading={isLoading} />
  )
}

export default SendPhone