"use client"
import { useEffect } from "react"
import Cookies from "universal-cookie"
import { useMutation } from "@tanstack/react-query"
import { useModalController } from "react-modal-pro"
import { THISPROJECT } from "@/constants/projects"
import { sendPhoneNumber } from "./sendPhone.services"
import SendPhoneModal from "./Modal"

const SendPhoneOnMount = () => {
  const { handleOpenModal, handleCloseModal } = useModalController("send_phone")

  const { isLoading, mutate } = useMutation({
    mutationKey: ["sendPhone"],
    mutationFn: async (phoneNumber: string) => {
      const token = new Cookies().get("token")
      return await sendPhoneNumber(Number(phoneNumber), token)
    },
    onSuccess(_, phoneNumber) {
      handleCloseModal()
      const cookies = new Cookies()
      cookies.set("phoneNumber", phoneNumber)
    },
    onError() {
      handleCloseModal()
    },
  })

  useEffect(() => {
    if (THISPROJECT.DEFAULT_LOCALE !== "fa_IR") return

    const cookies = new Cookies()
    const redirect = cookies.get("redirect")
    const phoneNumber = cookies.get("phoneNumber")
    const phoneModalDismissed = cookies.get("phoneModalDismissed")

    if (phoneNumber || phoneModalDismissed) return

    const redirectValues = THISPROJECT.REDIRECT_VALUES || ""
    if (redirect && redirectValues && redirectValues.split(",").includes(redirect)) {
      cookies.set("phoneModalDismissed", "true", { path: "/" })
      handleOpenModal()
    }
  }, [handleOpenModal])

  const handleSubmit = (phoneNumber: string) => mutate(phoneNumber)

  return <SendPhoneModal handleSubmit={handleSubmit} isLoading={isLoading} />
}

export default SendPhoneOnMount

