"use client"
import styled from "styled-components"
import ReactLoading from "react-loading"
import { useForm } from "react-hook-form"
import { AppFlex, Button, Typography } from "@/primitives"
import { IoMdInformationCircleOutline } from "react-icons/io"
import { ProSheet } from "react-modal-pro"

const modalKey = "send_phone"

type Props = {
  handleSubmit: (phoneNumber: string) => void
  isLoading: boolean
}

const SendPhoneModal = ({ handleSubmit, isLoading }: Props) => {

  const { watch, register, setValue, formState: { errors }, } = useForm({
    defaultValues: {
      phoneNumber: ""
    },
    mode: "onChange",
  });

  return (
    <ProSheet
      direction="bottom"
      swipeToClose={true}
      modalKey={modalKey}
      TriggerElement={null}
      sheetClassName="send_phone_sheet"
    >
      <div style={{ display: "flex", flexDirection: "column", height: "400px", justifyContent: "space-between" }}>
        <Root errorText={errors?.phoneNumber?.message}>
          <Typography textalign="center" fontWeight={700}>
            برای ادامه لطفا شماره موبایل خود را وارد کنید
          </Typography>
          <InputContainer errorText={errors.phoneNumber?.message} className="InputContainer">
            <input
              style={{
                outline: "none",
                backgroundColor: "#fff",
                height: "54px",
                borderRadius: "8px",
                padding: "4px",
                marginTop: "9px",
                width: "100%",
                fontSize: "16px",
                WebkitAppearance: "none",
                WebkitTapHighlightColor: "transparent",
                border: "1px solid #000",
                color: "inherit",
                fontFamily: "inherit",
              }}
              type="text"
              inputMode="numeric"
              autoComplete={"off"}
              autoCorrect="off"
              autoCapitalize="none"
              spellCheck={false}
              placeholder="مثال : ۰۹۱۲۰۰۰۰۰۰۰"
              {...register("phoneNumber", {
                onChange(event) {
                  setValue("phoneNumber", event.target.value.slice(0, 15));
                },
              })}
            />
            {errors.phoneNumber?.message && <IoMdInformationCircleOutline />}
          </InputContainer>
          <TextError>{errors.phoneNumber?.message}</TextError>
        </Root>
        <Button
          variant="checkout"
          onClick={() => handleSubmit(watch("phoneNumber"))}
          disabled={!!errors.phoneNumber?.message || isLoading}
        >
          {isLoading ? (
            <AppFlex justify="center">
              <ReactLoading color="#ffff" type="spin" width={20} height={20} />
            </AppFlex>
          ) : (
            <Typography>تایید وادامه</Typography>
          )}
        </Button>
      </div>
    </ProSheet>
  )
}

export default SendPhoneModal

const Root = styled.section<{ errorText: string | undefined }>`
  position: relative;
  display: flex;
  flex-direction: column;
  gap: 20px;
  direction: rtl;

  input {
    ::placeholder {
      opacity: 50%;
    }
  }

`;

const InputContainer = styled.div<{ errorText: string | undefined }>`
  p {
    color: ${({ errorText }) => (errorText ? `red` : "#000")};
    font-size: 14px;
  }

  svg {
    scale: 1.4;
    fill: red;
  }
`;

const TextError = styled.p`
  position: absolute;
  bottom: 35px;
  font-size: 10px;
  color: red;
  right: 25px;
`;