import styled from "styled-components";
import { colors } from "@/theme";

const initialSteps = ["choosePlan", "login", "quiz", "success"] as const

import * as React from "react"
import type { SVGProps } from "react"

const SquareInSquare = ({ stroke = "#CDCDCD", fill = "#CDCDCD", ...props }: SVGProps<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={32} height={32} fill="none" {...props}>
    <rect width={31.25} height={31.25} x={0.375} y={0.375} stroke={stroke} strokeWidth={0.75} rx={2.625} />
    <rect width={12} height={12} x={10} y={10} fill={fill} rx={1.5} />
  </svg>
)

const SquareCheckedFill = (props: SVGProps<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={32} height={32} fill="none" {...props}>
    <rect width={32} height={32} fill="#37CAA5" rx={4} />
    <path stroke="#fff" strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="m7.74 16.5 5.5 5.5 11.02-11" />
  </svg>
)

const labels = {
  "login": "ورود",
  "success": "شروع تغییر",
  "quiz": "شخصی‌سازی برنامه",
  "choosePlan": "انتخاب دوره"
}

const thisStep = {
  stepKey: "quiz",
  stepIndex: 2
}

const stepIcons = {
  false: SquareInSquare,
  true: SquareCheckedFill
}


const QuestionProgressSteps = () => {
  return (
    <Wrapper>
      <BackgroundBar />
      <ProgressBar widthPercent={thisStep.stepIndex * 33} />
      {initialSteps.map((step, index, ref) => {
        const isStepPassed =
          thisStep.stepIndex !== ref.length - 1 ? thisStep.stepIndex > index : true;

        const ThisIcon = stepIcons[`${isStepPassed}`];

        return (
          <StepItem key={step}>
            <ThisIcon
              width={32}
              height={32}
              stroke={isStepPassed || thisStep.stepIndex === index ? colors.primary : undefined}
              fill={isStepPassed || thisStep.stepIndex === index ? colors.primary : undefined}
            />
            <StepLabel isActive={isStepPassed || thisStep.stepIndex === index}>
              {labels[step]}
            </StepLabel>
          </StepItem>
        );
      })}
    </Wrapper>
  )
}

export default QuestionProgressSteps


const Wrapper = styled.div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  position: relative;
  max-width: 568px;
  width:calc(100% - 32px);
  margin:12px auto ;
`;

const BackgroundBar = styled.div`
  position: absolute;
  top: 16px;
  left: 0;
  width: 100%;
  height: 1.5px;
  background: #ADAAAA;
  z-index: 0;
`;

const ProgressBar = styled.div<{ widthPercent: number }>`
  position: absolute;
  top: 16px;
  right: 0;
  height: 1.5px;
  max-width: 100%;
  width: ${({ widthPercent }) => `${widthPercent}%`};
  background: ${colors.primary};
  z-index: 1;
`;

const StepItem = styled.div` 
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  gap: 4px;
  position: relative;
  z-index: 10;
  min-width: 48px;
  background: ${colors.white};
`;

const StepLabel = styled.span<{ isActive: boolean }>`
  font-weight: 700;
  font-size: 10px;
  color: ${({ isActive }) => (isActive ? colors.primary : '#ADAAAA')};
`;