"use client";

import { THISPROJECT } from "@/constants/projects";
import { useWindowScrollPositions } from "@/hooks";
import QuestionProgressBar from "@/layouts/header/QuestionProgressBar";
import Image from "next/image";
import { usePathname, useRouter } from "next/navigation";
import { FaArrowLeftLong, FaArrowRightLong } from "react-icons/fa6";
import { styled } from "styled-components";
import { QUESTION } from "@/types/questions";
import QuestionProgressSteps from "./QuestionProgressSteps";

/**
 * props
 * _______________________________________________________________________________
 */
type Props = {
  ip?: any;
  data: QUESTION
  progressType?: "default" | "steps"
};

const QuestionHeader = ({ ip, data, progressType }: Props) => {
  const pathname = usePathname().split("/") as string[];
  const { back } = useRouter();
  const scrollPosition = useWindowScrollPositions();
  const hasHeader = data?.hasHeader;
  const renderQuestionProgress = () => {
    if ((data && Number(data?.currentQuestion), hasHeader === "true")) {
      if (progressType === "steps") return <QuestionProgressSteps />
      return (
        <QuestionProgressBar
          allQuestions={data ? data?.allQuestions : ""}
          currentQuestion={data ? data?.currentQuestion : ""}
        />
      );
    }
  };

  const imageLoader = ({ src, width, quality }: { src: string; width: string; quality: string }) => {
    return `${src}?w=${width}&q=${quality || 75}`;
  };

  const getContentBasedOnLayoutSegmen = (pathname: string | null) => {
    if (
      data &&
      pathname &&
      pathname === "question" &&
      Number(data.currentQuestion) > 1 &&
      THISPROJECT.DEFAULT_LOCALE === "fa_IR"
    ) {
      return (
        <div style={{ cursor: "pointer" }}>
          <FaArrowRightLong onClick={back} />
        </div>
      );
    }

    if (
      data &&
      pathname &&
      pathname === "question" &&
      Number(data.currentQuestion) > 1 &&
      THISPROJECT.DEFAULT_LOCALE === "en_US"
    ) {
      return (
        <div
          onClick={back}
          style={{
            position: "absolute",
            left: "15px",
            cursor: "pointer",
            width: "50px",
            height: "30px",
            display: "flex",
            alignItems: "center",
          }}
        >
          <FaArrowLeftLong />
        </div>
      );
    }
  };

  if (data && data.hasHeader === 'false') return null
  return (
    <>
      {scrollPosition.scrollY > 60 && (
        <StickyHeader>
          <FaArrowLeftLong onClick={back} style={{ cursor: "pointer", position: "absolute", left: "15px" }} />
          <Image
            loader={imageLoader as any}
            src={THISPROJECT.LOGO_URL}
            alt={"header-logo"}
            width={100}
            height={30}
            className="logo"
            priority
          />
        </StickyHeader>
      )}

      <>
        <StaticHeader>
          {getContentBasedOnLayoutSegmen(pathname[1])}
          <Image
            loader={imageLoader as any}
            src={THISPROJECT.LOGO_URL}
            alt={"header-logod"}
            width={100}
            height={30}
            className="logo"
            priority
          />
        </StaticHeader>
        {renderQuestionProgress()}
      </>
    </>
  );
};

export default QuestionHeader;

const StaticHeader = styled.div`
  position: relative;
  width: 100%;
  padding: 8px 15px;
  display: flex;
  justify-content: center;
  align-items: center;
  background-color: #fff;
  z-index: 95;
  display: flex;
  justify-content: space-between;

  .logo {
    margin-inline: auto;
  }
`;

const StickyHeader = styled.header`
  position: fixed;
  width: 100%;
  padding: 8px 16px;
  top: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  background-color: #fff;
  z-index: 95;

  .logo {
    margin-inline: auto;
  }
`;
