"use client";

import { useEffect, useRef, type FC } from "react";
import styled from "styled-components";

interface VideoProps {
  link: string;
}

const Video: FC<VideoProps> = ({ link }) => {
  const videoRef = useRef<HTMLVideoElement | null>(null);

  // this useEffect stop video on finish time
  useEffect(() => {
    const videoElement = videoRef.current;

    const handleTimeUpdate = () => {
      if (videoElement) {
        const finishTime = videoElement.duration - 0.5;
        if (videoElement.currentTime >= finishTime) {
          videoElement.pause();
          videoElement.currentTime = finishTime;
        }
      }
    };

    videoElement?.addEventListener("timeupdate", handleTimeUpdate);

    return () => {
      videoElement?.removeEventListener("timeupdate", handleTimeUpdate);
    };
  }, []);

  return (
    <div style={{ minHeight: "100%" }}>
      <StyledVideo ref={videoRef} muted autoPlay playsInline>
        <source src={link} type="video/webm" />
      </StyledVideo>
    </div>
  );
};

export default Video;

const StyledVideo = styled.video`
  width: 100%;
  height: calc(100vh - 400px);

`;
