import React, { useState, useEffect } from 'react';
import Confetti from 'react-confetti';
import styled from 'styled-components';
import { FaCheckCircle } from "react-icons/fa";
import { colors } from '@/theme';
import { Button, Typography } from '@/primitives';

type Props = {
  handleClick: () => void
  buttonText?: string;
  inputs: {
    title: string,
    subtitle: string
    footer: string
  }
}

export default function ThankYouRoot({ handleClick, buttonText = "Create My Plan", inputs }: Props) {
  const [confettiActive, setConfettiActive] = useState(true);

  useEffect(() => {
    const timer = setTimeout(() => setConfettiActive(false), 15000);
    return () => clearTimeout(timer);
  }, []);

  return (
    <Container>
      {confettiActive && <Confetti style={{ position: 'fixed', width: '100%', height: '100%' }} />}
      <MessageContainer>
        <TitleContainer>
          <FaCheckCircle size={40} color={colors.primary} />
          <Title>
            {inputs.title}
          </Title>
        </TitleContainer>
        <Subtitle>
          {inputs.subtitle}
        </Subtitle>
        <Footer>
          {inputs.footer}
        </Footer>
      </MessageContainer>
      <Button variant="question" onClick={handleClick} position="fixed" key="button">
        <Typography>{buttonText}</Typography>
      </Button>
    </Container>
  );
}

const Container = styled.div`
  position: relative;
  height: calc(100vh - 155px);
  width: 100%;
`;

const MessageContainer = styled.div`
  display: flex;
  height: 100%;
  gap: 8px;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  text-align: center;
`;

const TitleContainer = styled.div`
  display: flex;
  gap: 10px;
  align-items: center;
`;

const Title = styled.h2`
  font-size: 30px;
  font-weight: bold;
  color: #000;
`;

const Subtitle = styled.p`
  font-size: 48px;
  margin-top: 10px;
  color: #000;

  @media (max-width: 768px) {
    font-size: 30px;
  }
`;

const Footer = styled.p`
  font-size: 20px;
  margin-top: 15px;
  color: #888;

  @media (max-width: 768px) {
    font-size: 14px;
  }
`;
