import React from 'react';
import styled, { keyframes } from 'styled-components';

interface ConfettiProps {
  left: number;
  delay: number;
  colors: string[];
}

const fall = keyframes`
  0% {
    top: -10px;
    opacity: 1;
  }
  100% {
    top: 100vh; 
    opacity: 0;
  }
`;

const ConfettiItem = styled.div<{ left: number; delay: number; colors: string[] }>`
  position: absolute;
  top: -10px;
  left: ${({ left }) => `${left}%`};
  width: 8px;
  height: 8px;
  background-color: ${({ colors }) => colors[Math.floor(Math.random() * colors.length)]};
  border-radius: 50%;
  z-index: 1;
  animation: ${fall} 3s ${({ delay }) => `${delay}s`} linear infinite;
`;

export default function Confetti({ left, delay, colors }: ConfettiProps) {
  return <ConfettiItem left={left} delay={delay} colors={colors} />;
}
