import React from 'react'
import styled from 'styled-components'

interface NutritionInfoTextProps {
  text: string
  textAlign?: string
  textSize?: string
  textColor?: string
  textWeight?: React.CSSProperties['fontWeight']
  as?: keyof JSX.IntrinsicElements
  className?: string
  style?: React.CSSProperties
}

const StyledTypography = styled.div<{
  $textAlign: string
  $textSize: string
  $textColor: string
  $textWeight: React.CSSProperties['fontWeight']
}>`
  text-align: ${({ $textAlign }) => $textAlign};
  font-size: ${({ $textSize }) => $textSize};
  color: ${({ $textColor }) => $textColor};
  font-weight: ${({ $textWeight }) => $textWeight};
`

const NutritionInfoText: React.FC<NutritionInfoTextProps> = ({
  text,
  textAlign = 'left',
  textSize = '16px',
  textColor = '#000',
  textWeight = '400',
  as = 'div',
  className,
  style,
}) => {
  return (
    <StyledTypography
      as={as}
      $textAlign={textAlign}
      $textSize={textSize}
      $textColor={textColor}
      $textWeight={textWeight}
      className={className}
      style={style}
    >
      {text}
    </StyledTypography>
  )
}

export default NutritionInfoText
