"use client"

import React, { useState, useEffect } from 'react';
import { AppFlex, Button, Typography } from '@/primitives';
import 'react-circular-progressbar/dist/styles.css';
import NutritionInfoHeader from './Header';
import NutritionInfoGoal from './Goal';
import NutritionInfoResult from './Result';
import NutritionInfoInstructions from './Instructions';
import { useQuestionContext } from '@/providers';
import Cookies from "universal-cookie";
import { Encode, setCookies } from '@/utils';

type Props = {
  handleClick: () => void;
  data: Items;
  buttonText: string;
  aid: string
};

export default function NutritionInfoRoot({ handleClick: parentHandleClick, data, aid, buttonText }: Props) {
  const { dispatch } = useQuestionContext();
  const cookie = new Cookies();
  const token = cookie.get("Authorization");
  const code = cookie.get("code");

  const [nutrition, setNutrition] = useState({
    carbs: "",
    calory: "",
    protein: "",
    fat: ""
  });


  useEffect(() => {
    const initialNutrition = data.result.nutritions.reduce((acc, { id, value }) => {
      if (id === "calory") acc.calory = value;
      if (id === "carbs") acc.carbs = value;
      if (id === "protein") acc.protein = value;
      if (id === "fat") acc.fat = value;
      return acc;
    }, { ...nutrition });

    setNutrition(initialNutrition);
  }, [data.result.nutritions]);

  // console.log({ nutrition });

  const handleNutritionChange = (field: keyof typeof nutrition, value: string) => {
    setNutrition(prev => ({
      ...prev,
      [field]: value
    }));
  };

  const handleClick = () => {
    setCookies(nutrition, {}, cookie);
    dispatch({
      type: "UPDATE_QUESTIONS",
      payload: {
        aid,
        carbs: Encode(nutrition.carbs),
        calory: Encode(nutrition.calory),
        fat: Encode(nutrition.fat),
        protein: Encode(nutrition.protein),
      },
    });

  };

  return (
    <AppFlex direction='column' gap='24px' justify='center' align='center'>
      <NutritionInfoHeader data={data.header} />
      <NutritionInfoGoal data={data.goal} />
      <NutritionInfoResult
        data={data.result}
        nutrition={nutrition}
        onNutritionChange={handleNutritionChange}
      />
      <NutritionInfoInstructions data={data.instructions} />
      <Button variant="question" onClick={handleClick} position={"fixed"} key={"button"}>
        <Typography>{buttonText}</Typography>
      </Button>
    </AppFlex>
  );
}

interface Item {
  key: string;
  text: string;
  textAlign: string;
  textSize: string;
  textColor: string;
  textWeight: string;
}

interface Nutrition {
  id: string;
  title: string;
  value: string;
  maxValue: string;
  unit: string;
  progressColor: string;
  editTitle: string;
}

interface HealthScore {
  icon: string;
  title: string;
  value: string;
}

interface InstructionItem {
  id: string;
  title: string;
  icon: string;
}

interface Instructions {
  title: Item;
  items: InstructionItem[];
}

interface Result {
  header: Item[];
  nutritions: Nutrition[];
  healthscore: HealthScore;
}

interface Items {
  header: Item[];
  goal: Item[];
  result: Result;
  instructions: Instructions;
}
