"use client"

import React from 'react';
import styled from 'styled-components';
import { AppFlex } from '@/primitives';
import NutritionInfoText from './Text';
import dynamic from 'next/dynamic';
const NutritionProgressCard = dynamic(() => import("./NutritionProgressCard"), { ssr: false })

type Props = {
  data: {
    header: {
      key: string;
      text: string;
      textAlign: string;
      textSize: string;
      textColor: string;
      textWeight: string;
    }[];
    nutritions: {
      id: string;
      title: string;
      value: string;
      maxValue: string;
      unit: string;
      progressColor: string;
      editTitle: string;
    }[];
    healthscore: {
      icon: string;
      title: string;
      value: string;
    };
  };
  nutrition: {
    carbs: string;
    calory: string;
    protein: string;
    fat: string;
  };
  onNutritionChange: (field: keyof {
    carbs: string;
    calory: string;
    protein: string;
    fat: string;
  }, value: string) => void;
};

export default function NutritionInfoResult({ data, nutrition, onNutritionChange }: Props) {
  return (
    <AppFlex
      style={{
        background: '#F4F5F7',
        flexDirection: "column",
        gap: "24px",
        padding: '16px',
        borderRadius: '24px',
        width: '100%',
        maxWidth: '500px',
      }}
    >
      <AppFlex direction="column" gap="4px">
        {data.header.map(
          ({ key, text, textAlign, textColor, textSize, textWeight }) => (
            <NutritionInfoText
              key={`${key}-${text}`}
              text={text}
              textAlign={textAlign as 'left' | 'center' | 'right' | 'justify'}
              textColor={textColor}
              textSize={textSize}
              textWeight={textWeight}
            />
          )
        )}
      </AppFlex>

      <GridContainer>
        {data.nutritions.map(
          ({ id, maxValue, progressColor, title, unit, value, editTitle }) => (
            <NutritionProgressCard
              key={id}
              id={id}
              title={title}
              value={nutrition[id as keyof typeof nutrition] || value}
              maxValue={maxValue}
              unit={unit}
              progressColor={progressColor}
              isHealthScore={false}
              editTitle={editTitle}
              onNutritionChange={onNutritionChange}
            />
          )
        )}

        <NutritionProgressCard
          key="healthscore"
          title={data.healthscore.title}
          value={data.healthscore.value}
          progressColor="#37CAA5"
          icon={data.healthscore.icon}
          isHealthScore={true}
        />
      </GridContainer>
    </AppFlex>
  );
}

const GridContainer = styled.div`
  display: grid;
  width: 100%;
  grid-template-columns:1fr 1fr;
  gap: 16px;
`;
