import { AppFlex, Typography } from '@/primitives'
import React from 'react'
import NutritionInfoText from './Text';
import Image from 'next/image';

type Props = {
  data: {
    title: {
      text: string;
      textAlign: string;
      textSize: string;
      textColor: string;
      textWeight: string;
    };
    items: {
      id: string;
      title: string;
      icon: string;
    }[];
  }
}

export default function NutritionInfoInstructions({ data }: Props) {
  return (
    <AppFlex
      direction="column"
      gap="24px"
      style={{
        background: '#F4F5F7',
        padding: '16px',
        borderRadius: '24px',
        width: '100%',
        maxWidth: '500px',
      }}
    >
      <NutritionInfoText
        text={data.title.text}
        textAlign={data.title.textAlign}
        textSize={data.title.textSize}
        textColor={data.title.textColor}
        textWeight={data.title.textWeight}
      />
      <AppFlex
        direction="column"
        gap="8px"
      >
        {data.items.map(({ id, icon, title }) => (
          <AppFlex key={id} style={{ background: "#fff", padding: "33px 16px", borderRadius: "16px" }}>
            <AppFlex align='center' gap='16px'>
              <Image src={icon} alt='icon' width={24} height={24} />
              <Typography style={{ fontSize: '14px', fontWeight: '500' }}>{title}</Typography>
            </AppFlex>
          </AppFlex>
        ))}
      </AppFlex>
    </AppFlex>
  )
}
