import { AppFlex } from '@/primitives'
import Image from 'next/image'
import React from 'react'
import NutritionInfoText from './Text'

type Props = {
  data: {
    key: string
    text: string;
    textAlign: string;
    textSize: string;
    textColor: string;
    textWeight: string;
  }[]
}

export default function NutritionInfoHeader({ data }: Props) {

  return (
    <AppFlex direction='column' gap='4px' justify='center' align='center'>
      <Image
        width={48}
        height={48}
        alt='tick-circle'
        src={`/svg/tick-circle.svg`}
      />
      {data.map(({ key, text, textAlign, textColor, textSize, textWeight }) => (
        <NutritionInfoText
          key={key}
          text={text}
          textAlign={textAlign}
          textColor={textColor}
          textSize={textSize}
          textWeight={textWeight}
        />
      ))}
    </AppFlex>
  )
}
