import { AppFlex } from '@/primitives';
import React from 'react'
import NutritionInfoText from './Text';

type Props = {
  data: {
    key: string
    text: string;
    textAlign: string;
    textSize: string;
    textColor: string;
    textWeight: string;
  }[]
}

export default function NutritionInfoGoal({ data }: Props) {
  return (
    <AppFlex direction='column' gap='8px'>
      {data.map(({ key, text, textAlign, textColor, textSize, textWeight }, index) => (
        <NutritionInfoText
          key={key}
          text={text}
          textAlign={textAlign}
          textColor={textColor}
          textSize={textSize}
          textWeight={textWeight}
          style={index === 1 ? { padding: '4px 7px', borderRadius: '14px', background: "#D7F4ED" } : {}}
        />
      ))}
    </AppFlex>
  )
}
