"use client";

import { IconElementInputs, PARASITE_QUESTION_TYPE_ENUM, QUESTION } from "@/types/questions";
import Text from "./Text";
import { AppFlex, Button, Typography } from "@/primitives";
import { useQuestionContext } from "@/providers";
import dynamic from "next/dynamic";
import styled from "styled-components";
import { setCookies } from "@/utils";
import Cookies from "universal-cookie";
import { useEffect, useId, useState } from "react";
import MultiLinearProgress from "./liner-box/MultiLinearProgress";
import { useRandomValue, useRandomValueMultiLoadingProgress } from "@/hooks";
import SummaryQuestionRoot from "./summary-question/SummaryQuestionRoot";
import ParasitChart from "./chart/ParasitChart";
import ParasitSingleChart from "./chart/ParasitSingleChart";
import NutritionInfoRoot from "./nutrition-info/Root";
import SliderRoot from "./slider/Root";
import ThankYouRoot from "./thank-you/Root";
import { thisLocale } from "@/constants/projects";

const ParasiteImage = dynamic(() => import("./ParasiteImage"));
const ParasiteComments = dynamic(() => import("./ParasiteComments"));
const ParasiteIcon = dynamic(() => import("./ParasiteIcon"));
const ParasiteLiner = dynamic(() => import("./liner-box/ParasiteLiner"));
const TransitionText = dynamic(() => import("./TransitionText"));
const TitleFade = dynamic(() => import("./title-fade/TitleFade"));
const Video = dynamic(() => import("./video/video"));
const RangeSlider = dynamic(() => import("./range-slider/range-slider"));

const LineChartProgressGoalWeight = dynamic(() => import("../parasite-question/chart/LineChartProgressGoalWeight"), {
  ssr: false,
});

const LineChartProgress = dynamic(() => import("../parasite-question/chart/LineChartProgress"), {
  ssr: false,
});

/**
 * props
 * _______________________________________________________________________________
 */
type Props = {
  question: QUESTION;
};

const ParasiteQuestionRootComponent = ({ question }: Props) => {
  // console.log({ question })
  /**
   * const and variables
   * _______________________________________________________________________________
   */
  const { preAid, allQuestions, code, token, currentQuestion, type, questionType } = question as QUESTION;
  const { dispatch } = useQuestionContext();
  const cookie = new Cookies();
  const [opacity, setOpacity] = useState(0);
  const [translate, setTranslate] = useState("40px");
  const { firstStep, secondStep, thirdStep } = useRandomValue();
  const { first, forth, second, third } = useRandomValueMultiLoadingProgress();
  const locale = thisLocale;
  useEffect(() => {
    localStorage.removeItem("timer");
  }, []);

  /**
   * useEffect
   * _______________________________________________________________________________
   */

  useEffect(() => {
    setTimeout(() => {
      setOpacity(1);
      setTranslate("0");
    }, 1);
  }, []);

  /**
   * hooks and methods
   * _______________________________________________________________________________
   */

  const handleClick = () => {
    const aidStr = question.answers[0].aid;
    dispatch({
      type: "UPDATE_QUESTIONS",
      payload: {
        aid: aidStr,
        type: type,
      },
    });

    const obj = {
      Authorization: token,
      type: type,
      code: code,
      preAid: preAid,
      currentQuestion: currentQuestion,
      allQuestions: allQuestions,
      questionType: questionType,
    };
    setCookies(obj, {}, cookie);
  };

  const renderElement = (element: { id: string; inputs: IconElementInputs | any }, index: number) => {
    switch (element.id) {
      // _______________________________________________________________________________ ICON
      case PARASITE_QUESTION_TYPE_ENUM.Icon:
        return <ParasiteIcon key={"icon"} inputs={element.inputs} />;

      // _______________________________________________________________________________ TITLE
      case PARASITE_QUESTION_TYPE_ENUM.Title:
        return (
          <AppFlex justify={locale === 'fa_IR' ? 'flex-start' : "center"}>
            <Text
              key={"title"}
              inputs={element.inputs}
              fontSize={Number(element.inputs.textSize) || 24}
              component="h1"
              isCenter={locale !== 'fa_IR'}
              variant="h2"
              textColor={question.parasite.textColor}
              style={{ textAlign: 'start' }}
            />
          </AppFlex>
        );

      // _______________________________________________________________________________ DESCRIPTION
      case PARASITE_QUESTION_TYPE_ENUM.Description:
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const id = useId();
        return (
          <Text
            key={`description${element.inputs.text}${id}`}
            style={{ textAlign: "start" }}
            inputs={element.inputs}
            variant="body2"
            component="p"
            textColor={question.parasite.textColor}
            questionType={questionType}
          />
        );

      // _______________________________________________________________________________ TRANSITION TEXT
      case PARASITE_QUESTION_TYPE_ENUM.TransitionText:
        return <TransitionText key={"transitionText"} inputs={element.inputs} />;

      // _______________________________________________________________________________ SINGLE CHART
      case PARASITE_QUESTION_TYPE_ENUM.SingleChart:
        return <ParasitSingleChart key={index} inputs={element?.inputs} />;

      // _______________________________________________________________________________ CHART
      case PARASITE_QUESTION_TYPE_ENUM.Chart:
        if (type == "fastfit") {
          return <ParasitChart key={"chart"} inputs={element?.inputs} />;
        } else {
          return <LineChartProgress key={index} inputs={element?.inputs} />;
        }

      // _______________________________________________________________________________ TITLE FADE
      case PARASITE_QUESTION_TYPE_ENUM.TitleFade:
        return (
          <TitleFade
            key={"TitleFade"}
            inputs={element.inputs}
            thisAid={question.parasite.aid}
            isResult={question.isResult}
            nextPage={question.nextPage}
            textColor={question.parasite.textColor}
          />
        );

      // _______________________________________________________________________________ SUMMARY
      case PARASITE_QUESTION_TYPE_ENUM.Summary:
        return <SummaryQuestionRoot key={"sammery"} data={element.inputs} aid={question.parasite.aid} />;

      // _______________________________________________________________________________ LOADING
      case PARASITE_QUESTION_TYPE_ENUM.Loading:
        return (
          <ParasiteLiner
            firstStep={firstStep}
            secondtStep={secondStep}
            thirdStep={thirdStep}
            key={"loading"}
            inputs={element.inputs as any}
            thisAid={question.answers[0].aid}
          />
        );

      // _______________________________________________________________________________ MULTI LOADING
      case PARASITE_QUESTION_TYPE_ENUM.MultiLoading:
        return (
          <MultiLinearProgress
            data={element.inputs}
            aid={question.answers[0].aid}
            key={index}
            firstStep={first}
            secondtStep={second}
            thirdStep={third}
            forthStep={forth}
            hasDisableBtn
          />
        );

      // _______________________________________________________________________________ COMMENTS
      case PARASITE_QUESTION_TYPE_ENUM.Comments:
        return (
          <ParasiteComments inputs={element.inputs} />
        );

      // _______________________________________________________________________________ IMAGE
      case PARASITE_QUESTION_TYPE_ENUM.Image:
        return <ParasiteImage key={"image"} inputs={element.inputs} />;

      // _______________________________________________________________________________ VIDEO
      case PARASITE_QUESTION_TYPE_ENUM.Video:
        return <Video link={element?.inputs?.link} />;

      // _______________________________________________________________________________ BUTTON
      case PARASITE_QUESTION_TYPE_ENUM.Button:
        return (
          <Button variant="question" onClick={handleClick} position={"fixed"} key={"button"}>
            <Typography>{element?.inputs?.text}</Typography>
          </Button>
        );

      // _______________________________________________________________________________ NUTRITION INFO
      case PARASITE_QUESTION_TYPE_ENUM.NutritionInfo:
        return (
          <NutritionInfoRoot
            handleClick={handleClick}
            data={element.inputs.items}
            buttonText={question.answers[0].text}
            aid={question.answers[0].aid}
          />
        );

      // _______________________________________________________________________________ SLIDER
      case PARASITE_QUESTION_TYPE_ENUM.Slider:
        return <SliderRoot handleClick={handleClick} inputs={element.inputs} buttonText={question.answers[0].text} />;

      // _______________________________________________________________________________ THANK YOU
      case PARASITE_QUESTION_TYPE_ENUM.ThankYou:
        return (
          <ThankYouRoot
            handleClick={handleClick}
            inputs={element.inputs.items}
            buttonText={question?.answers[0]?.text ?? "Create My Plan"}
          />
        );

      // _______________________________________________________________________________ RANGE SLIDER
      case PARASITE_QUESTION_TYPE_ENUM.RangeSlider:
        return <RangeSlider inputs={element.inputs} aid={question.answers[0].aid} buttonText={question?.answers[0]?.text || "Next"} />;

      // _______________________________________________________________________________ DEFAULT
      default:
        return null;
    }
  };

  const renderedElements = question?.parasite.elements.map((element, index) => renderElement(element, index));

  /**
   * template
   * _______________________________________________________________________________
   */
  return (
    <Root opacity={opacity} translate={translate}>
      {renderedElements}
    </Root>
  );
};

export default ParasiteQuestionRootComponent;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Root = styled.section<{ opacity: number; translate: string }>`
  display: flex;
  flex-direction: column;
  gap: 10px;
  opacity: ${props => props.opacity};
  margin-bottom: ${props => props.translate};
  transition:
    opacity 1.5s,
    margin 1.5s;
  padding-top: 20px;
`;

const CommentsWrapper = styled.section`
  height: min-content;
  /* bottom: 0px;
  position: relative;
  margin-top: -60px;

  @media (min-width: 850px) {
    position: absolute;
    margin-top: 0;
  } */
`;
