"use client"

import { CheckoutSlider } from '@/components/checkout';
import { usePlatform } from '@/hooks';
import { horizontalComments } from '@/types/checkout';
import { callFlutterHandlerOrFallback } from '@/utils/callFlutterHandlerOrFallback';
import React, { useEffect } from 'react'
import styled from 'styled-components';

type props = {
  inputs: horizontalComments
};

export default function ParasiteComments({ inputs }: props) {
  const { isIos, isWeb } = usePlatform()
  console.log({ inputs })
  useEffect(() => {
    if (isIos) {
      console.log("HERE")
      callFlutterHandlerOrFallback({
        flutterHandlerName: "rateUs",
        flutterHandlerParams: [],
      });
    }
  }, [isIos]);

  return (
    <CommentsWrapper style={{ width: "100%" }}>
      <CheckoutSlider horizontalComments={inputs} />
    </CommentsWrapper>
  )
}

const CommentsWrapper = styled.section`
  height: min-content;
`;