"use client";

import { AppFlex } from "@/primitives";
import { useState, type FC } from "react";
import styled from "styled-components";

type SingleTileSelectProps = {};

const SingleTileSelect: FC<SingleTileSelectProps> = () => {
  const [items, setItems] = useState([1, 2, 3, 4, 5]);

  return (
    <Root>
      <AppFlex justify="center" gap="10px">
        {items.map((item, index) => (
          <Tile key={index}>{item}</Tile>
        ))}
      </AppFlex>
      <AppFlex justify="space-between" align="center">
        <Caption>Yes, definitely</Caption>
        <Caption>Not at all</Caption>
      </AppFlex>
    </Root>
  );
};

export default SingleTileSelect;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Root = styled.div`
  display: flex;
  justify-content: center;
  flex-direction: column;
  gap: 10px;
  max-width: 300px;
  margin: 0 auto;
`;

const Tile = styled.span`
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 8px;
  color: black;
  width: 50px;
  height: 50px;
  border: 1px solid #999;
  transition: background-color 0.3s ease;
`;

const Caption = styled.div`
  font-size: 14px;
  color: #999;
`;
