"use client";

import { inputUnits } from "@/constants";
import { THISPROJECT, thisLocale } from "@/constants/projects";
import { AppFlex, Button, Typography } from "@/primitives";
import { useQuestionContext } from "@/providers";
import { Answer, QUESTION } from "@/types/questions";
import { Encode, extractNumbers, getCookies, setCookies } from "@/utils";
import { convertFootToCm } from "@/utils/question/convertFootToCm";
import { getBmi } from "@/utils/question/getBmi";
import { yupResolver } from "@hookform/resolvers/yup";
import Image from "next/image";
import { useEffect, useState } from "react";
import { useForm } from "react-hook-form";
import { IoMdInformationCircleOutline } from "react-icons/io";
import styled, { css } from "styled-components";
import TabInput from "./TabInput";
import { enUSValidationSchema, faIRValidationSchema, inputRegistertype, renderElement } from "./validationSchema";
import Cookies from "universal-cookie";
import { getLanguageFromCookiesClient } from "@/utils/question/getLanguage.client";
import { usePlatform } from "@/hooks";

/**
 * props
 * _______________________________________________________________________________
 */
type Props = {
  questionType: "height" | "weightCurrent" | "weightGoal" | "phoneNumber" | "age"
  answer: Answer;
  validation: QUESTION["validation"];
};



const InputQuestion = ({ answer, questionType, validation }: Props) => {
  /**
   * const and variables
   * _______________________________________________________________________________
   */
  const cookies = new Cookies()
  const [textError, setTextError] = useState("");
  const [FTƒtextError, setFttextError] = useState("");
  const [FIntextError, setFINtextError] = useState("");
  const { dispatch } = useQuestionContext();
  const language = getLanguageFromCookiesClient()
  const units = inputUnits.filter(item => item.questionType === questionType)[0];
  const { isIos, isWeb } = usePlatform()
  const defaultHeightUnit = thisLocale === 'fa_IR' ? "CM" : isIos ? "FT" : isWeb ? "FT" : "CM"

  const generateInitialUnit = () => {
    if (questionType === "height") {
      const heightUnit = getCookies()["height_unit"] ?? defaultHeightUnit
      return heightUnit
    }
    if (questionType === "weightCurrent") {
      const heightUnit = getCookies()["height_unit"] ?? defaultHeightUnit
      const weightUnit = heightUnit === "CM" ? "KG" : "LBS"
      return weightUnit
    }
    if (questionType === "weightGoal") {
      const weightUnit = getCookies()["weight_unit"] ?? "KG"
      return weightUnit
    }
    return units?.units[1]
  }
  const [unit, setUnit] = useState<string>(generateInitialUnit());
  const [bmi, setBmi] = useState<any>();
  const inputRegister = units?.inputRegistery?.filter(item => item.key === unit)[0]?.value as inputRegistertype;

  const validationSchema = THISPROJECT.DEFAULT_LOCALE === "fa_IR" ? faIRValidationSchema : enUSValidationSchema;
  const locale = thisLocale;
  const { type } = getCookies();
  const {
    register,
    reset,
    getValues,
    setValue,
    watch,
    setFocus,
    formState: { errors },
  } = useForm({
    resolver: yupResolver(validationSchema),
    mode: "onChange",
  });

  const errorMessage = Object.entries(errors)[0];
  const errorText = errorMessage ? errorMessage[1].message : "";
  /**
   * useEffect
   * _______________________________________________________________________________
   */

  useEffect(() => {
    setBmi("");
  }, [questionType, unit]);

  useEffect(() => {
    reset();
  }, [questionType, unit]);

  useEffect(() => {
    setFocus("height_cm");
  }, [setFocus]);

  /**
   * hooks and methods
   * _______________________________________________________________________________
   */

  const handleUnitSelect = (value: string) => {
    if (questionType !== "weightGoal") setUnit(value);
  }

  useEffect(() => {
    const cookieKeys: Record<string, string> = {
      height: "height_unit",
      weightCurrent: "weight_unit",
      weightGoal: "weight_unit"
    }
    const thisKey = cookieKeys[questionType]
    if (thisKey) {
      setCookies({ [thisKey]: unit }, {}, cookies);
    }
  }, [unit])

  useEffect(() => {
    if (questionType === "weightGoal") {
      const weightUnit = getCookies()["weight_unit"] ?? "KG"
      const otherUnit = units.units.find(item => item !== weightUnit) ?? "LBS"
      const thisTab = document.getElementById(otherUnit)
      if (thisTab) {
        thisTab.style.opacity = "0.3"
        thisTab.style.cursor = "default"
        thisTab.style.pointerEvents = "none"
        return () => {
          thisTab.style.opacity = "1"
          thisTab.style.cursor = "pointer"
          thisTab.style.pointerEvents = "auto"
        }
      }
    }
  }, [questionType])

  const handleFtInputValidation = () => {
    let validation = "";

    if (Number(watch("height_ft")) < 1 || Number(watch("height_ft")) > 99) {
      if (locale !== "fa_IR") {
        return (
          setFttextError("The number must be between 10 and 99."),
          (validation = "The number must be between 10 and 99.")
        );
      } else {
        return setFttextError("عدد باید بین ۱۰ و ۹۹ باشد"), (validation = "عدد باید بین ۱۰ و ۹۹ باشد");
      }
    } else {
      return setFttextError(""), (validation = "");
    }
  };

  const handleFINInputValidation = () => {
    let validation = "";

    if (Number(watch("height_in")) < 1 || Number(watch("height_in")) > 99) {
      if (locale !== "fa_IR") {
        return (
          setFINtextError("The number must be between 10 and 99."),
          (validation = "The number must be between 10 and 99.")
        );
      } else {
        return setFINtextError("عدد باید بین ۱۰ و ۹۹ باشد"), (validation = "عدد باید بین ۱۰ و ۹۹ باشد");
      }
    } else {
      return setFINtextError(""), (validation = "");
    }
  };

  const handleValidation = (value: any, type: string) => {
    let validation = "";
    // console.log({ type })
    // height_cm
    if (type === "height_cm") {
      if (Number(value) < 90 || Number(value) > 245) {
        if (locale !== "fa_IR") {
          return (
            setTextError("The height should be between 90 and 240"),
            (validation = "The height should be between 90 and 240")
          );
        } else {
          return setTextError("قد باید بین ۹۰ و ۲۴۰ باشد"), (validation = "قد باید بین ۹۰ و ۲۴۰ باشد");
        }
      } else {
        return setTextError(""), (validation = "");
      }
    }

    // age
    if (type === "age") {
      if (Number(value) < 10 || Number(value) > 110) {
        if (locale !== "fa_IR") {
          return (
            setTextError("Age should be between 10 to 110"),
            (validation = "Age should be between 10 to 110")
          );
        } else {
          return setTextError("سن باید بین 10 و 110 باشد"), (validation = "سن باید بین 10 و 110 باشد");
        }
      } else {
        return setTextError(""), (validation = "");
      }
    }

    // weight_current_lbs;
    if (
      type === "weight_current_lbs" ||
      type === "weight_goal_kg" ||
      type === "weight_current_kg" ||
      type === "weight_goal_lbs"
    ) {
      if (Number(value) < 40 || Number(value) > 240) {
        if (locale !== "fa_IR") {
          return (
            setTextError("Weight should be between 40 and 180"), (validation = "Weight should be between 40 and 180")
          );
        } else {
          return setTextError("وزن باید بین ۴۰ و ۲۴۰ باشد"), (validation = "وزن باید بین ۴۰ و ۲۴۰ باشد");
        }
      } else {
        return setTextError(""), (validation = "");
      }
    }
  };
  // this validation params coming from backend
  const handleBackendValidation = () => {
    const weightGoal = Number(getValues("weight_goal_kg"));
    if (questionType === "weightGoal") {
      if (weightGoal && (weightGoal > Number(validation.maxValid) || weightGoal < Number(validation.minValid))) {
        console.log("HERE2")
        setTextError(validation.invalidText);
        return true;
      }
    }

    return false;
  };
  // console.log(renderElement(inputRegister))
  const handleClick = () => {
    if (units.questionType === "height" && unit !== "CM") {
      localStorage.setItem("defaultUnit", "en");
      const heightCm = convertFootToCm(watch("height_ft") as string, watch("height_in") as string);
      localStorage.setItem("height", String(heightCm));
    }
    if (units.questionType === "height" && unit.includes("CM")) {
      localStorage.setItem("defaultUnit", "fa");
      localStorage.setItem("height", watch("height_cm") as string);
    }

    if (units.questionType === "weightCurrent" && unit !== "KG") {
      localStorage.setItem("defaultUnit", "en");
    }

    if (units.questionType === "weightCurrent" && unit.includes("KG")) {
      localStorage.setItem("defaultUnit", "fa");
    }
    if (units.questionType === "age") {
      localStorage.setItem("age", watch("age") as string);
    }
    if (units.questionType === "age") {
      localStorage.setItem("age", watch("age") as string);
    }
    handleValidation(
      watch(renderElement(inputRegister) as inputRegistertype),
      renderElement(inputRegister) as inputRegistertype
    );

    handleFtInputValidation();
    handleFINInputValidation();

    if (handleBackendValidation()) return;

    if (renderElement(inputRegister) === "height_ft") {
      if (handleFtInputValidation() === "" && handleFINInputValidation() === "") {
        dispatch({
          type: "UPDATE_QUESTIONS",
          payload: {
            type: type,
            aid: answer.aid,
            height_cm: watch().height_cm && Encode(watch().height_cm),
            height_ft: watch().height_ft && Encode(watch().height_ft),
            height_in: watch().height_in && Encode(watch().height_in),
            weight_current_kg: watch().weight_current_kg && Encode(watch().weight_current_kg),
            weight_current_lbs: watch().weight_current_lbs && Encode(watch().weight_current_lbs),
            weight_goal_kg: watch().weight_goal_kg && Encode(watch().weight_goal_kg),
            weight_goal_lbs: watch().weight_goal_lbs && Encode(watch().weight_goal_lbs),
            age: watch().age && Encode(watch().age),
          },

        });
      }
    }

    if (
      handleValidation(
        watch(renderElement(inputRegister) as inputRegistertype),
        renderElement(inputRegister) as inputRegistertype
      ) == ""
    ) {
      dispatch({
        type: "UPDATE_QUESTIONS",
        payload: {
          type: type,
          aid: answer.aid,
          height_cm: watch().height_cm && Encode(watch().height_cm),
          height_ft: watch().height_ft && Encode(watch().height_ft),
          height_in: watch().height_in && Encode(watch().height_in),
          weight_current_kg: watch().weight_current_kg && Encode(watch().weight_current_kg),
          weight_current_lbs: watch().weight_current_lbs && Encode(watch().weight_current_lbs),
          weight_goal_kg: watch().weight_goal_kg && Encode(watch().weight_goal_kg),
          weight_goal_lbs: watch().weight_goal_lbs && Encode(watch().weight_goal_lbs),
          age: watch().age && Encode(watch().age),
        },
      });
    }
  };

  const yearText = {
    "Br": "Anos",
    "en": "Years",
    "it": "Years",
    "PL": "Years",
    "Sp": "Years",
    "ir": "سال",
  }
  console.log({ bmi })
  /**
   * template
   * _______________________________________________________________________________
   */
  // console.log({ unit })
  return (
    <>
      <Root locale={THISPROJECT.DEFAULT_LOCALE} errortext={errorText}>
        {locale === "en_US" && unit !== "Years" &&
          <TabInput
            units={units?.units}
            unitSelected={unit}
            onUnitSelect={handleUnitSelect}
          />
        }
        {unit === "FT" ? (
          <HeightFtFlex style={{ position: "relative", width: "100%", margin: 'auto', maxWidth: '250px' }} gap="20px">
            <div style={{ position: "relative", width: "50%" }}>
              <InputContainer errortext={FTƒtextError} locale={locale}>
                <p>FT</p>
                <input
                  type="text"
                  inputMode="numeric"
                  style={{ width: "100%" }}
                  {...register("height_ft", {
                    onChange(event) {
                      const newValue = extractNumbers(event.target.value)
                      setValue("height_ft", newValue.slice(0, 2));
                      setFttextError("");
                    },
                  })}
                />
                {textError && <IoMdInformationCircleOutline />}
              </InputContainer>
              <TextError
                locale={THISPROJECT.DEFAULT_LOCALE}
                style={{ top: 200 }}
              >
                {FTƒtextError}
              </TextError>
            </div>
            <div style={{ position: "relative", width: "50%" }}>
              <InputContainer errortext={FIntextError} locale={locale}>
                <p>IN</p>
                <input
                  type="text"
                  inputMode="numeric"
                  style={{ width: "100%" }}
                  {...register("height_in", {
                    onChange(event) {
                      const newValue = extractNumbers(event.target.value)
                      setValue("height_in", newValue.slice(0, 2));
                      setFINtextError("");
                    },
                  })}
                />
                {textError && <IoMdInformationCircleOutline />}
              </InputContainer>
              <TextError
                locale={THISPROJECT.DEFAULT_LOCALE}
                style={{ top: 55 }}
              >
                {FIntextError}
              </TextError>
            </div>
          </HeightFtFlex>
        ) : (
          <>
            <InputContainer errortext={textError} className="InputContainer" id="input-container" locale={locale}>
              <p style={{
                textWrap: "nowrap",
                minWidth: "90px",
                position: "absolute",
                right: locale === "fa_IR" ? 30 : -30,
                // left: locale !== "fa_IR" ? 0 : 50,
                zIndex: 9
              }}>{unit}</p>

              <input
                type="text"
                inputMode="numeric"
                dir={thisLocale !== 'fa_IR' ? "ltr" : "ltr"}
                {...register(renderElement(inputRegister) as inputRegistertype, {
                  onChange(event) {
                    if (renderElement(inputRegister) === ("height_ft" as inputRegistertype)) {
                      const newValue = extractNumbers(event.target.value)
                      setValue(
                        renderElement(inputRegister) as inputRegistertype,
                        newValue.slice(0, 3)
                      );
                    } else {
                      const bmiValue = getBmi(
                        language,
                        Number(extractNumbers(watch(renderElement(inputRegister) as inputRegistertype) || "")),
                        Number(extractNumbers(localStorage.getItem("height") || "")),
                        getCookies()["weight_unit"] ?? "KG",
                      )
                      setBmi(bmiValue);
                      const newValue = extractNumbers(event.target.value)
                      setValue(
                        renderElement(inputRegister) as inputRegistertype,
                        newValue.slice(0, 3)
                      );
                    }
                    setTextError("");
                  },
                })}
              />
              {textError && <IoMdInformationCircleOutline />}
            </InputContainer>
            <TextError
              locale={THISPROJECT.DEFAULT_LOCALE}
              style={{ top: locale !== 'fa_IR' ? 140 : 50 }}
            >
              {textError}
            </TextError>
          </>
        )}
      </Root >
      {Boolean(answer.hint?.description) && (
        <section
          style={{
            backgroundColor: "#EBF5FF",
            padding: "15px 10px",
            borderRadius: "8px",
            display: "flex",
            flexDirection: "column",
            gap: "10px",
          }}
        >
          <div style={{ display: "flex", alignItems: "center", gap: "5px" }}>
            <Image alt="" width={30} height={30} src={answer.hint?.icon as string} />
            <p style={{ color: "#757575", fontWeight: 600 }}>{answer.hint?.title}</p>
          </div>
          <p style={{ color: "#757575", fontSize: "12px" }}>{answer.hint?.description}</p>
        </section>
      )
      }
      {
        questionType === "weightCurrent" && Number(bmi?.value) > 0 && (
          <section
            style={{
              backgroundColor: "#EBF5FF",
              padding: "15px 10px",
              borderRadius: "8px",
              display: "flex",
              flexDirection: "column",
              gap: "10px",
            }}
          >
            <div style={{ display: "flex", alignItems: "center", gap: "5px" }}>
              <Image alt="" width={30} height={30} src={bmi.icon as string} />
              <p style={{ color: "#757575", fontWeight: 600 }}>{bmi.title}</p>
            </div>
            <p style={{ color: "#757575", fontSize: "12px" }}>{bmi.description}</p>
          </section>
        )
      }
      <Button
        onClick={handleClick}
        variant="question"
        disabled={!Boolean(watch((inputRegister) as any))}
        style={{ marginBlock: "15px" }}
      >
        <Typography fontWeight={700}>{answer.text}</Typography>
      </Button>
    </>
  );
};

export default InputQuestion;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Root = styled.section<{ errortext: string | undefined; locale: string }>`
  display: flex;
  flex-direction: column;
  gap: 40px;
  width: 100%;
  margin: auto;
  position: relative;
  padding-bottom: 10px;

  & .InputContainer:focus-within {
    border: ${({ errortext }) => (errortext ? `1.5px solid red` : "2px solid #02857a")};

    input {
      font-family: ${({ locale }) => (locale == "en_US" ? `revert` : "unset")};
    }
  }

  label {
    color: ${({ errortext }) => (errortext ? `red` : "#000")};
  }
`;

const HeightFtFlex = styled(AppFlex)`
  @media (max-width: 440px) {
    justify-content: center;
    align-items: center;
  }
`

const InputContainer = styled.div<{ errortext: string | undefined, locale: ProjectLocale }>`
  display: flex;
  align-items: center;
  justify-content: center;
  max-width: 250px;
  gap: 5px;
  border: ${({ errortext }) => (errortext ? `1.5px solid red` : "2px solid #02857A")};
  height: 50px;
  border-radius: 4px;
  position: relative;
  padding-inline: 5px;
  margin: auto;
  width: 100%;

  input {
    outline: none;
    height: 100%;
    border: none;
    font-size: 14px;
    padding-inline: ${({ locale }) => (locale === 'fa_IR' ? "0 100px 0 0" : "0 0 0 100px")}; 
    background-color: transparent;
    z-index: 10;

    &:-webkit-autofill,
    &:-webkit-autofill:hover,
    &:-webkit-autofill:focus,
    &:-webkit-autofill:active {
      z-index: 1;
      -webkit-background-clip: text;
      transition: background-color 5000s ease-in-out 0s #fff;
      box-shadow: inset 0 100px 100px 20px #fff;
    }

    color: ${({ errortext }) => (errortext ? `red` : "#000")};
    width: -webkit-fill-available;
  }

  p {
    color: ${({ errortext }) => (errortext ? `red` : "#000")};
    font-size: 14px;
  }

  svg {
    scale: 1.4;
    fill: red;
  }


`;

const TextError = styled.p<{ locale: string }>`
  position: absolute;
  bottom: -12px;
  font-size: 12px;
  color: red;

  ${({ locale }) =>
    locale === "en_US"
      ? css`
          left: 0;
        `
      : css`
          right: 0;
        `};
`;

const Lable = styled.label<{ locale: string }>`
  user-select: none;
  position: absolute;
  top: 60px;
  font-size: 14px;

  ${({ locale }) =>
    locale === "en_US"
      ? css`
          left: 5px;
        `
      : css`
          right: 5px;
        `};
`;
