"use client";

import { AppFlex, Typography } from "@/primitives";
import { styled } from "styled-components";
import Slider from "rc-slider";
import { TiArrowSortedDown } from "react-icons/ti";
import { thisLanguage } from "@/constants/projects";
import { useWindowSize } from "@/hooks";

interface LineBarProps {
  value: number;
  scaleList: string[];
  thisLabel: string;
}

const LineBarV2 = ({ scaleList, thisLabel, value }: LineBarProps) => {
  const { width } = useWindowSize();
  const isMoble = width < 600;
  const lableValue = isMoble ? value - 10 : value - 7;

  return (
    <Container id="lineBarContainer" direction="column" gap={"20px"}>
      <AppFlex align="center" style={{ width: "100%", position: "relative", minHeight: "35px" }}>
        <Lable value={lableValue}>
          <Typography textalign="center" style={{ lineHeight: "20px" }} textcolor="#fff" fontSize={12}>
            {thisLabel}
          </Typography>
          <AppFlex style={{ position: "absolute", right: "40%", bottom: -10 }}>
            <TiArrowSortedDown />
          </AppFlex>
        </Lable>
      </AppFlex>
      <Slider min={0} max={100} value={value} />
      <AppFlex justify={"space-around"} direction={thisLanguage === "fa" ? "row" : "row"}>
        {scaleList?.map((item, i) => {
          return (
            <Typography key={item + i} textcolor="#D1D5DA" style={{ fontSize: '10px', textAlign: 'center' }}>
              {item}
            </Typography>
          );
        })}
      </AppFlex>
    </Container>
  );
};

export default LineBarV2;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Container = styled(AppFlex)`
  padding: 16px;

  .rc-slider-rail {
    margin-top: -3px;
    height: 10px;
    background: linear-gradient(
      90deg,
      #fc806e 0%,
      #e6ff08b2 20%,
      #b7f5a8 50%,
      #e6ff08b2 80%,
      #fc806e 100%
    );
    opacity: 1;
  }

  .rc-slider-track {
    background: transparent !important;
  }

  .rc-slider-handle {
    transition: all 2s ease-in;
    background-color: #fff;
    border: 1px solid #fff;
    z-index: 10;
    width: 20px;
    height: 20px;
    opacity: 1 !important;
    margin-top: -9px;
    box-shadow:
      0 2px 6px rgb(36 36 36 / 45%),
      0 12px 24px rgb(36 36 36 / 20%);
  }
`;


const Lable = styled(AppFlex) <{ value: any }>`
  position: absolute;
  padding-block: 5px;
  padding-inline: 5px;
  transition: all 2s ease-in;
  left: ${({ value }) => value && `${value - 10}%`};
  background-color: #757575;
  border-radius: 4px;
  max-width: 70px;
  display: flex;
  justify-content: center;

  svg {
    fill: #757575;
  }
`;
