import { THISPROJECT, thisLanguage } from "@/constants/projects";
import { PreCheckoutResultProps, PreCheckoutResultPropsV2 } from "@/types/pre-checkout";
import { ApiManager } from "@/utils/axios.config";

type PreCheckout = {
  data: PreCheckoutResultProps;
  message: string;
  result: PreCheckoutResultProps;
  success: string;
};

type PreCheckoutV2 = {
  data: PreCheckoutResultPropsV2;
  message: string;
  result: PreCheckoutResultPropsV2;
  success: string;
};

type getPreCheckoutProps = {
  Authorization: string | undefined;
  code: string | undefined;
  userIpAddress?: string | any;
};

export const getPreCheckout = async ({ Authorization, code, userIpAddress }: getPreCheckoutProps) => {
  try {
    const res = await ApiManager.get<PreCheckout>("/main/preCheckout.php", {
      params: {
        Authorization: Authorization,
        code: code,
        language: "fa",
        userIpAddress: userIpAddress,
      },
    });
    if (res["data"]["success"] === "false") return { error: res["data"]["message"] };
    const response = res.data.data;

    return response;
  } catch (error) {
    error: THISPROJECT.GLOBAL_ERROR;
  }
};

export const getPreCheckoutV2 = async ({ Authorization, code, userIpAddress }: getPreCheckoutProps) => {
  console.log({ Authorization, code, userIpAddress })
  try {

    const res = await ApiManager.get<PreCheckoutV2>("/main/preCheckoutV2.php", {
      params: {
        Authorization: Authorization,
        code: code,
        language: "fa",
        userIpAddress: userIpAddress,
      },
    });
    console.log({ RESSSSSSSSSSSSSS: res })
    if (res["data"]["success"] === "false") return { error: res["data"]["message"] };
    const response = res.data.data;
    return response;
  } catch (error) {
    console.log({ ERRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR: error })
    error: THISPROJECT.GLOBAL_ERROR;
  }
};
