"use client"

import { AppFlex, Typography } from '@/primitives';
import Image from 'next/image';
import React from 'react'
import styled from 'styled-components';
// import Warning from "../../../../public/images/warning.png";

type Props = {
    thisWarning: {
        title: string
        description: string
    }
}

export default function PreCheckoutWarning({ thisWarning }: Props) {
    const { title, description } = thisWarning
    const loaderProp = ({ src }: { src: string }) => {
        return src;
    };
    return (
        <WarningContainer align="center" gap={"20px"}>
            <WarningSVGContainer justify="center" align="center">
                <Image src={'/images/warning.png'} alt="Warning-svg" width={25} height={25} loader={loaderProp} />
            </WarningSVGContainer>
            <AppFlex direction="column" align="flex-start" gap={"10px"}>
                <Typography variant="body1" fontWeight={600} fontSize={16}>
                    {title}
                </Typography>
                <Typography variant="subtitle2" textcolor="#663C01">
                    {description}
                </Typography>
            </AppFlex>
        </WarningContainer>
    )
}


const WarningContainer = styled(AppFlex)`
  background-color: #fff3e5;
  padding: 16px;
  border-radius: 8px;
  margin-top: 10px;

`;

const WarningSVGContainer = styled(AppFlex)`
  background-color: #fde3bf;
  min-width: 52px;
  height: 55px;
  border-radius: 10px;
`;

