"use client";

import { AppFlex, Typography } from "@/primitives";
import Image from "next/image";
import { useEffect, useState } from "react";
import { styled } from "styled-components";
import { thisLanguage } from "@/constants/projects";
import { ResultBoxListItem } from "@/types/pre-checkout";
import Warning from "../../../../public/images/warning.png";
import LineBarV2 from "../result-box/LineBarV2";

/**
 * props
 * _______________________________________________________________________________
 */

type ParamObject = {
  title: string,
  image: string
  params: {
    key: string
    title: string
    value: string
  }[]
  lineBar: {
    title: string
    value: string,
    label: string,
    scaleList: string[]
  }
};

type ResultOfProgramProps = {
  params: {
    after: ParamObject
    before: ParamObject
  }
};

const PreCheckoutResult = ({ params }: ResultOfProgramProps) => {

  const loaderProp = ({ src }: { src: string }) => {
    return src;
  };

  return (
    <AppFlex direction="column">
      <Header>
        <Typography fontSize={16} fontWeight={700} className="typo">
          {params.before.title}
        </Typography>
        <div className="divider" />
        <Typography fontSize={16} fontWeight={700} className="typo">
          {params.after.title}
        </Typography>
      </Header>
      <ImageWrapper>
        <div className="image-wrapper">
          <Image
            loader={loaderProp}
            className="width-image"
            alt="user-image"
            src={params.before.image}
            fill
            style={{ objectFit: "contain" }}
          />
        </div>
        <div className="image-wrapper">
          <Image
            loader={loaderProp}
            className="width-image"
            alt="user-image"
            src={params.after.image}
            fill
            style={{ objectFit: "contain" }}
          />
        </div>
      </ImageWrapper>
      <UserInfoContainer>
        <AppFlex className="wrapper" direction="column">
          {params.before.params.map(({ key, title, value }: any) => {
            return (
              <AppFlex className="wrapper" direction="column" style={{ width: '100%' }} key={key}>
                {key !== "metabolism" && (
                  <>
                    <Typography fontSize={16} fontWeight={700} style={{ minHeight: "20px" }}>
                      {title}
                    </Typography>
                    <Typography fontSize={12} fontWeight={300} style={{ minHeight: "20px" }}>
                      {value || "—"}
                    </Typography>
                    <div className="horizontal-divider" />
                  </>
                )}
                {key === 'metabolism' && (
                  <MetabolismLevel direction="column" gap="10px">
                    <Typography fontSize={16} fontWeight={700} style={{ minHeight: '20px' }}>
                      {title}
                    </Typography>
                    <AppFlex gap="2px">
                      {Array(5)
                        .fill({})
                        .map((item, index) => {
                          return (
                            <div
                              key={index}
                              className="card"
                              style={{ backgroundColor: `${index + 1 > Number(value) ? "#fff" : "#3AD7AB"}` }}
                            />
                          );
                        })}
                    </AppFlex>
                    <div className="horizontal-divider" />
                  </MetabolismLevel>
                )}
              </AppFlex>
            )
          })}
          <LineBarV2
            scaleList={params.before.lineBar.scaleList}
            value={Number(params.before.lineBar.value)}
            thisLabel={params.before.lineBar.label}
          />
        </AppFlex>
        <AppFlex className="wrapper" direction="column">
          {params.after.params.map(({ key, title, value }: any) => {
            return (
              <AppFlex className="wrapper" direction="column" style={{ width: '100%' }} key={key}>
                {key !== "metabolism" && (
                  <>
                    <Typography fontSize={16} fontWeight={700} style={{ minHeight: "20px" }}>
                      {title}
                    </Typography>
                    <Typography fontSize={12} fontWeight={300} style={{ minHeight: "20px" }}>
                      {value || "—"}
                    </Typography>
                    <div className="horizontal-divider" />
                  </>
                )}
                {key === 'metabolism' && (
                  <MetabolismLevel direction="column" gap="10px">
                    <Typography fontSize={16} fontWeight={700} style={{ minHeight: '20px' }}>
                      {title}
                    </Typography>
                    <AppFlex gap="2px">
                      {Array(5)
                        .fill({})
                        .map((item, index) => {
                          return (
                            <div
                              key={index}
                              className="card"
                              style={{ backgroundColor: `${index + 1 > Number(value) ? "#fff" : "#3AD7AB"}` }}
                            />
                          );
                        })}
                    </AppFlex>
                    <div className="horizontal-divider" />

                  </MetabolismLevel>
                )}
              </AppFlex>
            )
          })}
          <LineBarV2
            scaleList={params.after.lineBar.scaleList}
            value={Number(params.after.lineBar.value)}
            thisLabel={params.after.lineBar.label}
          />
        </AppFlex>
      </UserInfoContainer>
    </AppFlex>
  )
};

export default PreCheckoutResult;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Header = styled(AppFlex)`
  background-color: #f1efee;
  padding: 10px;
  width: 100%;
  justify-content: space-between;
  border-top-left-radius: 10px;
  border-top-right-radius: 10px;

  .typo {
    width: 49%;
    text-align: center;
  }

  .divider {
    background-color: #fff;
    min-height: 20px;
    min-width: 2px;
    border-radius: 10px;
  }
`;

const ImageWrapper = styled(AppFlex)`
  width: 100%;
  background: radial-gradient(85% 85% at 50% 50%, #fefefe 26.94%, #ddcdd0 100%);
  .image-wrapper {
    width: 50%;
    position: relative;
    min-height: 70vw;
    object-fit: cover;

    .width-image {
      width: 98% !important;
      margin: auto;
    }

    @media (min-width: 500px) {
      min-height: 280px;

      .width-image {
        width: 70% !important;
        margin: auto;
      }
    }
  }
`;

const UserInfoContainer = styled(AppFlex)`
  border-bottom-left-radius: 10px;
  border-bottom-right-radius: 10px;
  background-color: #f1efee;
  padding: 10px;
  width: 100%;
  justify-content: space-between;

  .wrapper {
    width: 48%;
  }

  .divider {
    background-color: #fff;
    min-height: 20px;
    height: auto;
    min-width: 2px;
    border-radius: 10px;
    margin-inline: 15px;
  }

  .horizontal-divider {
    background-color: #fff;
    min-height: 1px;
    width: 100%;
    border-radius: 10px;
    margin-block: 10px;
  }
`;

const MetabolismLevel = styled(AppFlex)`
  .card {
    width: 17px;
    height: 4px;
    background-color: #fff;
  }
`;
