import React from "react";
import { PreCheckoutResultPropsV2 } from "@/types/pre-checkout";
import PreCheckoutHeader from "../shared/PreCheckoutHeader";
import PreCheckoutBanner from "../shared/PreCheckoutBanner";
import PercentageBox from "../shared/PercentageBox";
import PreCheckoutButton from "../shared/PreCheckoutButton";
import PreCheckoutResult from "./PreCheckoutResult";
import PreCheckoutWarning from "./PreCheckoutWarning";
import { Typography } from "@/primitives";
import PreCheckoutVideoPlayer from "./PreCheckoutVideoPlayer";
import { cookies } from "next/headers";
import { getPreCheckoutV2 } from "../preCheckout.services";
import { redirect } from "next/navigation";
import MainLoding from "../../../../app/question/loading";

type Props = {
  Authorization?: string;
  code?: string;
  type?: string;
};

const PreCheckoutMainV2 = async ({ Authorization, code, type }: Props) => {
  const cookieStore = cookies()
  const userIpAddress = cookieStore.get("user-ip-address")?.value;
  const res = (await getPreCheckoutV2({
    Authorization,
    code,
    userIpAddress,
  })) as PreCheckoutResultPropsV2;
  if (!res) return <MainLoding />
  const { button, header, params, percentage, warning, hint, videoUrl, videoTitle } = res
  if (params.before.params.length < 1 || params.before.params === undefined) {
    redirect(`/error`);
  }
  return (
    <>
      <PreCheckoutHeader />
      <section style={{ paddingTop: "45px" }}>
        <PreCheckoutBanner bgColor={header?.bgColor} text={header?.text} image={header?.image} />
        <section
          style={{
            gap: "10px",
            display: "flex",
            flexDirection: "column",
            maxWidth: "600px",
            margin: "auto",
            paddingInline: "16px",
          }}
        >
          {/* <Typography color="#767A86" fontSize={18} fontWeight={500} lineHeight={1.5} style={{ marginTop: "10px" }}>
            {videoTitle}
          </Typography> */}
          <PreCheckoutResult params={params} />
          <PreCheckoutWarning thisWarning={warning} />
          {videoUrl && <PreCheckoutVideoPlayer videoUrl={videoUrl} videoTitle={videoTitle} />}
          {hint &&
            <Typography color="#767A86" fontSize={12} fontWeight={300} lineHeight={1.5} style={{ marginTop: "10px" }}>
              {hint}
            </Typography>
          }
          <PercentageBox
            type={"fit"}
            thisValue={Number(percentage?.value)}
            description={percentage?.description}
            showBox={true}
          />
        </section>
        <PreCheckoutButton inputs={button} />
      </section>
    </>
  );
};

export default PreCheckoutMainV2;
