import { THISPROJECT } from "@/constants/projects";
import { getLanguageFromCookiesServer } from "@/utils/question/getLanguage.server";
import axios from "axios";

const axiosBase = axios.create({ baseURL: THISPROJECT.PRE_CONNECT_SERVER_URL });

export const confirmPayPalFetcher: any = async (code: string) => {
  const language: ProjectLanguage = await getLanguageFromCookiesServer();
  const res = await axiosBase.get("/process/payment/confirmpay.php", {
    params: {
      code: code,
      language,
    },
  });
  return res["data"];
};
