"use client";

import { AppFlex, Typography } from "@/primitives";
import Image from "next/image";
import { useEffect, useState } from "react";
import { styled } from "styled-components";
import { thisLanguage } from "@/constants/projects";
import { ResultBoxListItem } from "@/types/pre-checkout";
import LineBarV2 from "@/components/pre-checkout/result-box/LineBarV2";
import Warning from "../../../../public/images/warning.png";

/**
 * props
 * _______________________________________________________________________________
 */

type ParamObject = {
  [key: string]: {
    title: string;
    value: string;
  };
};

type ResultOfProgramProps = {
  beforeItems: ResultBoxListItem[]
  afterItems: ResultBoxListItem[]
  beforeThisValue: number;
  afterThisValue: number
  warningTitle?: string;
  warningDescription?: string;
  lineBarLabel: string;
  scaleList: string[];
  content: {
    hint: string;
    title: string;
    after: {
      title: string;
      image: string;
      param1: {
        title: string;
        value: string;
      };
      param2: {
        title: string;
        value: string;
      };
      param3?: {
        title: string;
        value: string;
      };
      param4?: {
        title: string;
        value: string;
      };
      param5?: {
        title: string;
        value: string;
      };
      param6?: {
        title: string;
        value: string;
      };
    };
    before: {
      title: string;
      image: string;
      param1: {
        title: string;
        value: string;
      };
      param2: {
        title: string;
        value: string;
      };
      param3?: {
        title: string;
        value: string;
      };
      param4?: {
        title: string;
        value: string;
      };
      param5?: {
        title: string;
        value: string;
      };
      param6?: {
        title: string;
        value: string;
      };
    };
  };
};

const ResultOfProgramV2 = ({
  content,
  beforeItems,
  afterItems,
  beforeThisValue,
  afterThisValue,
  warningTitle,
  warningDescription,
  lineBarLabel,
  scaleList }: ResultOfProgramProps) => {
  /**
   * const and variables
   * _______________________________________________________________________________
   */
  const { after, before, hint, title } = content;
  const [beforeValue, setBeforeValue] = useState(0);
  const [afterValue, setAfterValue] = useState(0);
  const [updatedContent, setUpdatedContent] = useState(content);

  useEffect(() => {
    setBeforeValue(thisLanguage === "fa" ? 100 - beforeThisValue : beforeThisValue);
    setAfterValue(thisLanguage === "fa" ? 100 - afterThisValue : afterThisValue);

    const mappedAfter = afterItems.reduce<ParamObject>((acc, item, index) => {
      if (item.title && item.description) {
        acc[`param${index + 3}`] = {
          title: item.title,
          value: item.description || "",
        };
      }
      return acc;
    }, {});

    const mappedBefore = beforeItems.reduce<ParamObject>((acc, item, index) => {
      if (item.title && item.description) {
        acc[`param${index + 3}`] = {
          title: item.title,
          value: item.description || "",
        };
      }
      return acc;
    }, {});

    setUpdatedContent((prev) => ({
      ...prev,
      before: {
        ...prev.before,
        ...mappedBefore,
      },
      after: {
        ...prev.after,
        ...mappedAfter,
      },
    }));
  }, [beforeItems, afterItems, beforeThisValue, afterThisValue]);

  /**
   * useEffect
   * _______________________________________________________________________________
   */

  /**
   * hooks and methods
   * _______________________________________________________________________________
   */

  const loaderProp = ({ src }: { src: string }) => {
    return src;
  };

  /**
   * template
   * _______________________________________________________________________________
   */
  return (
    <AppFlex direction="column">
      <Header>
        <Typography fontSize={16} fontWeight={700} className="typo">
          {updatedContent.before.title}
        </Typography>
        <div className="divider" />
        <Typography fontSize={16} fontWeight={700} className="typo">
          {updatedContent.after.title}
        </Typography>
      </Header>
      <ImageWrapper>
        <div className="image-wrapper">
          <Image
            loader={loaderProp}
            className="width-image"
            alt="user-image"
            src={before.image}
            fill
            style={{ objectFit: "contain" }}
          />
        </div>
        <div className="image-wrapper">
          <Image
            loader={loaderProp}
            className="width-image"
            alt="user-image"
            src={after.image}
            fill
            style={{ objectFit: "contain" }}
          />
        </div>
      </ImageWrapper>
      <UserInfoContainer>
        <AppFlex className="wrapper" direction="column">
          {Object.keys(updatedContent.before)
            .filter((key) => key.startsWith("param"))
            .map((paramKey) => {
              const param = (updatedContent.before as any)[paramKey];
              return (
                <AppFlex className="wrapper" direction="column" style={{ width: '100%' }} key={paramKey}>
                  <Typography fontSize={16} fontWeight={700} style={{ minHeight: "20px" }}>
                    {param.title}
                  </Typography>
                  <Typography fontSize={12} fontWeight={300} style={{ minHeight: "20px" }}>
                    {param.value || "—"}
                  </Typography>
                  <div className="horizontal-divider" />
                </AppFlex>
              );
            })}
          <div className="horizontal-divider" />
          <MetabolismLevel direction="column" gap="10px">
            <Typography fontSize={16} fontWeight={700} style={{ minHeight: '20px' }}>
              {updatedContent.before.param2.title}
            </Typography>
            <AppFlex gap="2px">
              {Array(5)
                .fill({})
                .map((item, index) => {
                  return (
                    <div
                      key={index}
                      className="card"
                      style={{ backgroundColor: `${index + 1 > Number(before.param2.value) ? "#fff" : "#3AD7AB"}` }}
                    />
                  );
                })}
            </AppFlex>
          </MetabolismLevel>
          <div className="horizontal-divider" />
          <LineBarV2
            scaleList={scaleList}
            value={beforeValue}
            thisLabel={lineBarLabel}
          />
          <div className="horizontal-divider" />
        </AppFlex>
        <div className="divider" />
        <AppFlex className="wrapper" direction="column">
          {Object.keys(updatedContent.after)
            .filter((key) => key.startsWith("param"))
            .map((paramKey) => {
              const param = (updatedContent.after as any)[paramKey];
              return (
                <AppFlex className="wrapper" direction="column" style={{ width: '100%' }} key={paramKey}>
                  <Typography fontSize={16} fontWeight={700} style={{ minHeight: "20px" }}>
                    {param.title}
                  </Typography>
                  <Typography fontSize={12} fontWeight={300} style={{ minHeight: "20px" }}>
                    {param.value || "—"}
                  </Typography>
                  <div className="horizontal-divider" />
                </AppFlex>
              );
            })}
          <div className="horizontal-divider" />
          <MetabolismLevel direction="column" gap="10px">
            <Typography fontSize={16} fontWeight={700} style={{ minHeight: '20px' }}>
              {updatedContent.after.param2.title}
            </Typography>
            <AppFlex gap="3px">
              {Array(5)
                .fill({})
                .map((item, index, array) => {
                  return (
                    <div
                      key={index}
                      className="card"
                      style={{ backgroundColor: `${index > Number(after.param2.value) ? "#fff" : "#3AD7AB"}` }}
                    />
                  );
                })}
            </AppFlex>
          </MetabolismLevel>
          <div className="horizontal-divider" />
          <LineBarV2
            scaleList={scaleList}
            value={afterValue}
            thisLabel={lineBarLabel}
          />
          <div className="horizontal-divider" />
        </AppFlex>
      </UserInfoContainer>
      <WarningContainer align="center" gap={"20px"}>
        <WarningSVGContainer justify="center" align="center">
          <Image src={Warning} alt="Warning-svg" width={25} height={25} loader={loaderProp} />
        </WarningSVGContainer>
        <AppFlex direction="column" align="flex-start" gap={"10px"}>
          <Typography variant="body1" fontWeight={600} fontSize={16}>
            {warningTitle}
          </Typography>
          <Typography variant="subtitle2" textcolor="#663C01">
            {warningDescription}
          </Typography>
        </AppFlex>
      </WarningContainer>
      <Typography color="#767A86" fontSize={12} fontWeight={300} lineHeight={1.5} style={{ marginTop: "10px" }}>
        {hint}
      </Typography>
    </AppFlex>
  );
};

export default ResultOfProgramV2;

/**
 * styled-component
 * _______________________________________________________________________________
 */

const Header = styled(AppFlex)`
  background-color: #f1efee;
  padding: 10px;
  width: 100%;
  justify-content: space-between;
  border-top-left-radius: 10px;
  border-top-right-radius: 10px;

  .typo {
    width: 49%;
    text-align: center;
  }

  .divider {
    background-color: #fff;
    min-height: 20px;
    min-width: 2px;
    border-radius: 10px;
  }
`;

const ImageWrapper = styled(AppFlex)`
  width: 100%;
  background: radial-gradient(85% 85% at 50% 50%, #fefefe 26.94%, #ddcdd0 100%);
  .image-wrapper {
    width: 50%;
    position: relative;
    min-height: 70vw;
    object-fit: cover;

    .width-image {
      width: 98% !important;
      margin: auto;
    }

    @media (min-width: 500px) {
      min-height: 280px;

      .width-image {
        width: 70% !important;
        margin: auto;
      }
    }
  }
`;

const UserInfoContainer = styled(AppFlex)`
  border-bottom-left-radius: 10px;
  border-bottom-right-radius: 10px;
  background-color: #f1efee;
  padding: 10px;
  width: 100%;
  justify-content: space-between;

  .wrapper {
    width: 48%;
  }

  .divider {
    background-color: #fff;
    min-height: 20px;
    height: auto;
    min-width: 2px;
    border-radius: 10px;
    margin-inline: 15px;
  }

  .horizontal-divider {
    background-color: #fff;
    min-height: 1px;
    width: 100%;
    border-radius: 10px;
    margin-block: 10px;
  }
`;

const MetabolismLevel = styled(AppFlex)`
  .card {
    width: 17px;
    height: 4px;
    background-color: #fff;
  }
`;

const WarningContainer = styled(AppFlex)`
  background-color: #fff3e5;
  padding: 16px;
  border-radius: 8px;
  margin-top: 10px;

`;

const WarningSVGContainer = styled(AppFlex)`
  background-color: #fde3bf;
  min-width: 52px;
  height: 55px;
  border-radius: 10px;
`;

