import { ApiManager } from "@/utils/axios.config";
import Cookies from "universal-cookie";

export const sendPhoneNumber = async (phoneNumber: number, href: string, token: string) => {
  const cookies = new Cookies()
  const res = await ApiManager.get("/login/setPhone.php", {
    params: {
      phoneNumber: phoneNumber,
      href: href,
      token: token,
      redirect: cookies.get("redirect")
    },
  });
  return res.data;
};

export const sendVerificationCode = async (
  phoneNumber: number | string,
  verificationCode: string,
  code: string,
  href: string,
) => {
  const cookies = new Cookies()
  const res = await ApiManager.get("/login/verifyPhone.php", {
    params: {
      phoneNumber: `${phoneNumber}`,
      verification: verificationCode,
      code: code,
      href: href,
      redirect: cookies.get("redirect"),
      payCode: cookies.get("payCode")
    },
  });
  return res.data;
};
