import { thisLanguage } from "@/constants/projects";
import { NextApiResponse } from "next";
import { cookies } from "next/headers";
import { NextRequest } from "next/server";
import { NextResponse } from "next/server";

export const middleware = async (request: NextRequest, res: NextApiResponse) => {
  const queryParams = request.nextUrl.href.split("/")[5];
  const ip = (request.headers.get("x-forwarded-for") ?? "127.0.0.1").split(",")[0];
  let response = NextResponse.next();
  response.cookies.set("user-ip-address", ip);

  const url = request.nextUrl.clone();
  const { pathname, searchParams } = url;


  if (pathname.startsWith('/question')) {

    const segments = pathname.split('/').filter(Boolean);
    let typeParam = null;
    let tokenParam = null;
    let phoneParam = null;
    let redirectParam = null;
    let referralParam = null;

    segments.forEach(segment => {
      const keyValuePairs = segment.split('&');
      keyValuePairs.forEach(pair => {
        const [key, value] = pair.split('=');
        if (key === 'type' && value) {
          typeParam = value;
        }
        if (key === 'redirect' && value) {
          redirectParam = value;
        }
        if (key === 'token' && value) {
          tokenParam = value
        }
        if (key === 'phone' && value) {
          phoneParam = value
        }
        if (key === 'referral' && value) {
          referralParam = value
        }
      });
    });
    if (typeParam) {
      const lang = extractLanguageCode(typeParam) ?? thisLanguage
      const response = NextResponse.next();
      response.cookies.set('lang', lang, {
        path: '/',
        httpOnly: false,
        sameSite: 'lax',
        secure: process.env.NODE_ENV === 'production',
        maxAge: 60 * 60 * 24 * 30,
      });
      if (redirectParam) {
        response.cookies.set("redirect", String(redirectParam), {
          path: '/',
          httpOnly: false,
          sameSite: 'lax',
          secure: process.env.NODE_ENV === 'production',
          maxAge: 60 * 60 * 24 * 30,
        });
      }
      if (searchParams.get("token") && searchParams.get("referral")) {
        response.cookies.set("referral", String(searchParams.get("referral")), {
          path: '/',
          httpOnly: false,
          sameSite: 'lax',
          secure: process.env.NODE_ENV === 'production',
          maxAge: 60 * 60 * 24 * 30,
        })
        response.cookies.set("phone", String(searchParams.get("phone")), {
          path: '/',
          httpOnly: false,
          sameSite: 'lax',
          secure: process.env.NODE_ENV === 'production',
          maxAge: 60 * 60 * 24 * 30,
        })
        response.cookies.set("Authorization", String(searchParams.get("token")), {
          path: '/',
          httpOnly: false,
          sameSite: 'lax',
          secure: process.env.NODE_ENV === 'production',
          maxAge: 60 * 60 * 24 * 30,
        })
      }
      return response;
    }
  }
  if (pathname.startsWith('/confirmPay')) {
    const response = NextResponse.next();
    if (cookies().get("phoneNumber")?.value && cookies().get("phoneNumberVerified")?.value && cookies().get("next")?.value) {
      return NextResponse.redirect(cookies().get("next")!.value)
    }
    if (searchParams.get("next")) {
      response.cookies.set("next", String(searchParams.get("next")), {
        path: '/',
        httpOnly: false,
        sameSite: 'lax',
      })
      return response
    }
  }
  return NextResponse.next();
}

function extractLanguageCode(typeParam: string) {
  const parts = typeParam.split('_');
  return parts.length > 1 ? parts[1] : "fa";
}

export const config = {
  unstable_allowDynamic: ["/node_modules/lodash/**"],
  matcher: ["/", "/question/:path*", "/checkout", "/question", "/checkout:path*", "/confirmPay"],
};
