import { MetadataRoute } from 'next'

const BASE_URL = 'https://quiz.matchadiet.com';

function escapeUrl(url: string): string {
  return url.replace(/&/g, '&amp;');
}

export default function sitemap(): MetadataRoute.Sitemap {
  return [
    {
      url: escapeUrl(`${BASE_URL}/question/aid=start&type=fit`),
      lastModified: new Date(),
      changeFrequency: 'daily',
      priority: 0.9,
    },
    {
      url: escapeUrl(`${BASE_URL}/question/aid=start&type=fastfit`),
      lastModified: new Date(),
      changeFrequency: 'daily',
      priority: 0.9,
    },
    {
      url: `${BASE_URL}/preCheckout`,
      lastModified: new Date(),
      changeFrequency: 'weekly',
      priority: 0.7,
    },
    {
      url: `${BASE_URL}/checkout`,
      lastModified: new Date(),
      changeFrequency: 'weekly',
      priority: 0.5,
    },
    {
      url: `${BASE_URL}/confirmPay`,
      lastModified: new Date(),
      changeFrequency: 'weekly',
      priority: 0.3,
    },
  ];
}