"use client";
import { THISPROJECT } from "@/constants/projects";
import React from "react";
import styled, { keyframes } from "styled-components";

const MainLoding = () => {

  return (
    <LoaderContainer>
      <SpinningLogo src={`/images/${THISPROJECT.PROJECT.toLowerCase()}/logo.png`} alt="Loading..." />
    </LoaderContainer>
  );
};

export default MainLoding;

const pulse = keyframes`
  0% {
    transform: scale(1);
    opacity: 1;
  }
  50% {
    transform: scale(1.3);
    opacity: 0.7;
  }
  100% {
    transform: scale(1);
    opacity: 1;
  }
`;

const LoaderContainer = styled.div`
  width: 100%;
  height: calc(100vh - 66px);
  display: flex;
  justify-content: center;
  align-items: center;
  background: "#fff";
`;

const SpinningLogo = styled.img`
  width: 100px;  
  height: 100px;  
  animation: ${pulse} 1.2s ease-in-out infinite;
`;
